/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.util.NBTJsonUtil;
import noppes.npcs.util.Util;

public class PlayerDataController {
    public static PlayerDataController instance;

    public PlayerDataController() {
        CustomNpcs.debugData.start(null);
        instance = this;
        File dir = CustomNpcs.getWorldSaveDirectory("playerdata");
        if (dir == null) {
            return;
        }
        for (File playerDir : Objects.requireNonNull(dir.listFiles())) {
            if (playerDir.isDirectory() || !playerDir.getName().endsWith(".json")) continue;
            try {
                File tempFile;
                File playerDirTemp;
                File banksDirTemp;
                NBTTagCompound nbt = NBTJsonUtil.LoadFile(playerDir);
                String uuid = "nouuidplayer";
                String name = "nonameplayer";
                if (nbt.func_150297_b("PlayerName", 8) && !nbt.func_74779_i("PlayerName").isEmpty()) {
                    name = nbt.func_74779_i("PlayerName");
                }
                if (nbt.func_150297_b("UUID", 8) && !nbt.func_74779_i("UUID").isEmpty()) {
                    uuid = nbt.func_74779_i("UUID");
                }
                if ((banksDirTemp = CustomNpcs.getWorldSaveDirectory("playerdata/" + uuid + "/banks")) == null) {
                    CustomNpcs.debugData.end(null);
                    return;
                }
                if (!banksDirTemp.exists()) {
                    banksDirTemp.mkdirs();
                }
                if (nbt.func_150297_b("BankData", 9)) {
                    for (int i = 0; i < nbt.func_150295_c("BankData", 10).func_74745_c(); ++i) {
                        NBTTagCompound nbtOldBank = nbt.func_150295_c("BankData", 10).func_150305_b(i);
                        NBTTagCompound nbtBD = new NBTTagCompound();
                        int bankID = nbtOldBank.func_74762_e("DataBankId");
                        nbtBD.func_74768_a("id", bankID);
                        int maxCells = nbtOldBank.func_74762_e("UnlockedSlots");
                        NBTTagList list = new NBTTagList();
                        for (int c = 0; c < nbtOldBank.func_150295_c("BankInv", 10).func_74745_c(); ++c) {
                            NBTTagCompound nbtOldCeil = nbtOldBank.func_150295_c("BankInv", 10).func_150305_b(c);
                            int ceilID = nbtOldCeil.func_74762_e("Slot");
                            if (ceilID >= maxCells) continue;
                            NBTTagCompound nbtCeil = new NBTTagCompound();
                            int slots = 27;
                            for (int u = 0; u < nbtOldBank.func_150295_c("UpdatedSlots", 10).func_74745_c(); ++u) {
                                if (nbtOldBank.func_150295_c("UpdatedSlots", 10).func_150305_b(u).func_74762_e("Slot") != ceilID) continue;
                                if (!nbtOldBank.func_150295_c("UpdatedSlots", 10).func_150305_b(u).func_74767_n("Boolean")) break;
                                slots = 54;
                                break;
                            }
                            NpcMiscInventory inv = new NpcMiscInventory(slots);
                            inv.load(nbtOldCeil.func_74775_l("BankItems"));
                            nbtCeil.func_74768_a("ceil", ceilID);
                            nbtCeil.func_74768_a("slots", slots);
                            NBTTagCompound invNbt = inv.save();
                            nbtCeil.func_74782_a("NpcMiscInv", invNbt.func_74781_a("NpcMiscInv"));
                            list.func_74742_a((NBTBase)nbtCeil);
                        }
                        nbtBD.func_74782_a("ceils", (NBTBase)list);
                        File bankFile = new File(banksDirTemp, bankID + ".dat");
                        if (!bankFile.exists()) {
                            try {
                                bankFile.createNewFile();
                            }
                            catch (Exception e) {
                                LogWriter.error(e);
                            }
                        }
                        try {
                            CompressedStreamTools.func_74799_a((NBTTagCompound)nbtBD, (OutputStream)Files.newOutputStream(bankFile.toPath(), new OpenOption[0]));
                            continue;
                        }
                        catch (Exception e) {
                            LogWriter.error(e);
                        }
                    }
                }
                if (!(playerDirTemp = new File(dir, uuid)).exists()) {
                    playerDirTemp.mkdirs();
                }
                if (!(tempFile = new File(playerDirTemp, name + ".json")).exists()) {
                    try {
                        tempFile.createNewFile();
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                }
                try {
                    nbt.func_82580_o("BankData");
                    Util.instance.saveFile(tempFile, nbt);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
                Util.instance.removeFile(playerDir);
            }
            catch (Exception e) {
                LogWriter.error("Error loading Old file: " + playerDir.getAbsolutePath(), e);
            }
        }
        CustomNpcs.debugData.end(null);
    }

    public void addPlayerMessage(MinecraftServer server, String username, PlayerMail mail) {
        PlayerData data = this.getDataFromUsername(server, username);
        if (data != null) {
            data.mailData.addMail(mail);
            data.save(false);
        }
    }

    public PlayerData getDataFromUsername(MinecraftServer server, String user_name_or_uuid) {
        EntityPlayerMP player = server.func_184103_al().func_152612_a(user_name_or_uuid);
        if (player == null) {
            try {
                player = server.func_184103_al().func_177451_a(UUID.fromString(user_name_or_uuid));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PlayerData data = null;
        if (player == null) {
            File playerDir = this.getPlayerDirectory(user_name_or_uuid);
            if (playerDir != null) {
                data = new PlayerData();
                for (File f : Objects.requireNonNull(playerDir.listFiles())) {
                    if (!f.isFile() || !f.getName().endsWith(".json")) continue;
                    try {
                        NBTTagCompound nbt = NBTJsonUtil.LoadFile(f);
                        if (!nbt.func_150297_b("GameData", 10)) continue;
                        data.setNBT(nbt);
                        data.uuid = playerDir.getName();
                        if (data.playername != null && !data.playername.isEmpty()) continue;
                        data.playername = f.getName().substring(0, f.getName().lastIndexOf("."));
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                }
            }
        } else {
            data = PlayerData.get((EntityPlayer)player);
        }
        return data;
    }

    private File getPlayerDirectory(String user_name_or_uuid) {
        for (File playerDir : Objects.requireNonNull(Objects.requireNonNull(CustomNpcs.getWorldSaveDirectory("playerdata")).listFiles())) {
            if (!playerDir.isDirectory()) continue;
            if (playerDir.getName().equalsIgnoreCase(user_name_or_uuid)) {
                return playerDir;
            }
            for (File file : Objects.requireNonNull(playerDir.listFiles())) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().replace(".json", "").equalsIgnoreCase(user_name_or_uuid)) continue;
                return playerDir;
            }
        }
        return null;
    }

    public List<String> getPlayerNames() {
        ArrayList<String> list = new ArrayList<String>();
        block0: for (File playerDir : Objects.requireNonNull(Objects.requireNonNull(CustomNpcs.getWorldSaveDirectory("playerdata")).listFiles())) {
            if (!playerDir.isDirectory()) continue;
            for (File file : Objects.requireNonNull(playerDir.listFiles())) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                list.add(file.getName().replace(".json", ""));
                continue block0;
            }
        }
        return list;
    }

    public List<PlayerData> getPlayersData(ICommandSender sender, String username) throws CommandException {
        ArrayList<PlayerData> list = new ArrayList<PlayerData>();
        List players = EntitySelector.func_179656_b((ICommandSender)sender, (String)username, EntityPlayerMP.class);
        if (players.isEmpty()) {
            PlayerData data;
            MinecraftServer server = CustomNpcs.Server;
            if (server == null) {
                server = sender.func_184102_h();
            }
            if ((data = this.getDataFromUsername(Objects.requireNonNull(server), username)) != null) {
                list.add(data);
            }
        } else {
            for (EntityPlayer player : players) {
                list.add(PlayerData.get(player));
            }
        }
        return list;
    }

    public String hasPlayer(String user_name_or_uuid) {
        File playerDir = this.getPlayerDirectory(user_name_or_uuid);
        if (playerDir == null) {
            return "";
        }
        return playerDir.getName();
    }
}

